#!/bin/bash
export datasets1="Cora CiteSeer PubMed OGBN-Arxiv"
export datasets2="OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=3

for p in 4
do
for q in 0.25 0.5 1 2 4
do
python main.py --dataset Cora --missing_type uniform --embedder Node2Vec_loss --p ${p} --q ${q} --n_runs 1 --gpu ${gpu}
python main.py --dataset OGBN-Arxiv --missing_type uniform --embedder Node2Vec_loss --p ${p} --q ${q} --n_runs 1 --gpu ${gpu}
done
done